"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
const path = __importStar(require("path"));
const fs = __importStar(require("fs/promises"));
const utils = __importStar(require("./../utils/index.js"));
const build_g_config_json_1 = __importDefault(require("./../build/build-g-config.json"));
const index_js_1 = __importDefault(require("./../lang/index.js"));
let dirname = '';
class Version {
    dir;
    baseDir;
    two;
    constructor(dir, baseDir) {
        dirname = baseDir;
        this.dir = dir;
        this.two = process.argv[3] || '';
    }
    async start() {
        const workDir = utils.join(dirname, this.dir);
        const mblerConfig = await utils.GetData(workDir);
        const packager = JSON.parse(await fs.readFile(path.join(workDir, 'package.json'), {
            encoding: 'utf-8'
        }).catch(() => ("{}")));
        if (typeof this.two === 'string' && utils.isVerison(this.two)) {
            packager.version = this.two;
            mblerConfig.version = this.two;
        }
        console.log(`${index_js_1.default.workPackV || '当前工作目录包版本：'} ${mblerConfig.version || '0.0.1'}`);
        await Promise.all([
            this.write(path.join(workDir, build_g_config_json_1.default.PackageFile), mblerConfig),
            this.write(path.join(workDir, 'package.json'), packager)
        ]);
    }
    write(p, c) {
        return fs.writeFile(p, JSON.stringify(c, null, 2));
    }
}
module.exports = Version;
