"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
const fs = __importStar(require("fs/promises"));
const utils = __importStar(require("../utils/index.js"));
const index_js_1 = __importDefault(require("./../loger/index.js"));
const path = __importStar(require("path"));
const build_g_config_json_1 = __importDefault(require("./../build/build-g-config.json"));
const index_js_2 = require("./../commander/index.js");
const mcVersion_js_1 = require("./../build/mcVersion.js");
let dirname = '';
class Init {
    dir;
    dirName;
    constructor(dir, name) {
        dirname = name;
        this.dir = dir;
        this.dirName = name;
    }
    async start() {
        if (!(await utils.FileExsit(this.dir))) {
            index_js_1.default.w('init', '无效的配置');
            return;
        }
        if (await utils.isMblerProject(this.dir)) {
            index_js_1.default.i('init', '已经初始化过了');
            return;
        }
        const name = await this.input('项目名称: ');
        const description = await this.input('项目描述: ');
        const mcVersion = await this.input('支持的minecraft版本: ');
        const packageer = {
            name,
            description,
            version: "0.0.1",
            engines: { node: ">=20.0.0" },
            scripts: {
                dev: "mbler dev",
                build: "MBLER_BUILD_MODULE=dist mbler build",
                "dev-build": "MBLER_BUILD_MODULE=dev mbler build"
            },
            dependencies: Object.create(null)
        };
        const ManiFest = {
            name,
            description,
            mcVersion,
            version: "0.0.1",
            minify: false
        };
        if ((await this.input('使用Script Api吗？(Y/N) ')).toLowerCase() === 'y') {
            ManiFest.script = {};
            ManiFest.script.main = (await this.input('主脚本路径(如 ./index.js): ')) || "index";
            ManiFest.script.ui = (await this.input('使用 UI 吗？(Y/N) ')).toLowerCase() === 'y';
            if (ManiFest.script.ui) {
                packageer.dependencies["@minecraft/server-ui"] = mcVersion_js_1.mcVersionGeter.ToServerUi(mcVersion);
            }
            await Promise.all([
                fs.mkdir(path.join(this.dir, 'behavior', "script"), { recursive: true }),
                fs.mkdir(path.join(this.dir, 'resources'), { recursive: true }),
            ]);
            const e = await index_js_2.Input.select("选择语言", ["ts", "js", "mcx"]);
            ManiFest.script.lang = e;
            if (e === "ts") {
                packageer.dependencies["@minecraft/server"] = mcVersion_js_1.mcVersionGeter.ToServer(mcVersion);
            }
        }
        ManiFest.outdir = {
            resources: "./dist/res",
            behavior: "./dist/dep",
            dist: "./dist.mcaddon"
        };
        await fs.writeFile(path.join(this.dir, 'package.json'), JSON.stringify(packageer, null, 2));
        await fs.writeFile(path.join(this.dir, build_g_config_json_1.default.PackageFile), JSON.stringify(ManiFest, null, 2));
    }
    async getVersion(param) {
        let v;
        let fall = false;
        while (true) {
            v = await utils.input(fall ? '格式错误，重新输入: ' + param : param);
            if (utils.isVerison(v))
                break;
            fall = true;
        }
        return v;
    }
    async input(param, t = false) {
        return (await utils.input((t ? '不符合规范，重试: ' : '') + param)) || this.input(param, true);
    }
}
module.exports = Init;
