"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const promises_1 = __importDefault(require("fs/promises"));
const utils = __importStar(require("./../utils/index.js"));
const index_js_1 = __importDefault(require("./../loger/index.js"));
const path_1 = __importDefault(require("path"));
const index_js_2 = __importDefault(require("./../lang/index.js"));
class Clean {
    p;
    dirname;
    outdir = [];
    constructor(p, baseDir) {
        this.p = p;
        this.dirname = baseDir;
    }
    run = () => this.start().catch((err) => {
        index_js_1.default.e(err);
    });
    async start() {
        if (!await utils.FileExsit(this.p)) {
            utils.Exit(`项目不存在`);
        }
        // 获取 mbler.config.json
        try {
            const packager = await utils.GetData(this.p);
            // 提取输出目录
            this.outdir = [
                /*resources*/
                this.getOutDir(packager.outdir?.resources),
                /*behavior*/
                this.getOutDir(packager.outdir?.behavior)
            ];
            await Promise.all(this.outdir.map((dir) => promises_1.default.rm(dir, {
                recursive: true,
                force: true
            }).catch(() => { })));
        }
        catch (err) {
            index_js_1.default.e('clean', err);
        }
        index_js_1.default.i('clean', index_js_2.default.cleanFinally);
    }
    getOutDir(dir) {
        const outdir = dir;
        return outdir ? utils.join(this.p, outdir) : path_1.default.join(this.p, 'dist');
    }
}
exports.default = Clean;
