"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GameStateError = exports.GameEngineError = exports.GameManagerError = exports.GameError = void 0;
class GameError extends Error {
    constructor(mes, options) {
        super(mes, options);
        this.name = "GameError";
    }
}
exports.GameError = GameError;
class GameManagerError extends GameError {
    constructor(mes, options) {
        super(mes, options);
        this.name = this.constructor.name;
    }
}
exports.GameManagerError = GameManagerError;
class GameEngineError extends GameError {
    constructor(mes, options) {
        super(mes, options);
        this.name = this.constructor.name;
    }
}
exports.GameEngineError = GameEngineError;
class GameStateError extends GameError {
    constructor(mes, options) {
        super(mes, options);
        this.name = this.constructor.name;
    }
}
exports.GameStateError = GameStateError;
