"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.createGameModule = exports.RunnerManager = exports.ScriptCancelledError = exports.ScriptRunner = exports.GameStructure = exports.GameContext = exports.GameEngine = exports.Utils = exports.Game = void 0;
exports.initSAPIGame = initSAPIGame;
const server_1 = require("@minecraft/server");
const config_js_1 = require("./config.js");
const constants_js_1 = require("./constants.js");
const gameEvent_js_1 = require("./gameEvent/gameEvent.js");
const gameCommand_js_1 = require("./system/gameCommand.js");
const gameManager_js_1 = require("./system/gameManager.js");
const globalPlayerManager_js_1 = require("./system/globalPlayerManager.js");
exports.Game = {
    /**框架预定义事件 */
    events: new gameEvent_js_1.gameEvents(),
    /**游戏管理器 */
    manager: new gameManager_js_1.GameManager(),
    playerManager: new globalPlayerManager_js_1.globalPlayerManager(),
    constants: constants_js_1.Constants,
    /**全局配置 */
    config: config_js_1.SAPIGameConfig,
};
/**使用配置初始化框架 */
function initSAPIGame(config) {
    config_js_1.SAPIGameConfig.update(config);
}
//注册指令
server_1.system.beforeEvents.startup.subscribe((t) => {
    (0, gameCommand_js_1.regGameCommand)(t.customCommandRegistry);
});
__exportStar(require("./gameRegion/index.js"), exports);
exports.Utils = __importStar(require("./utils/index.js"));
__exportStar(require("./gameComponent/index.js"), exports);
__exportStar(require("./gameState/index.js"), exports);
__exportStar(require("./gamePlayer/index.js"), exports);
var gameEngine_js_1 = require("./gameEngine.js");
Object.defineProperty(exports, "GameEngine", { enumerable: true, get: function () { return gameEngine_js_1.GameEngine; } });
var gameContext_js_1 = require("./gameContext.js");
Object.defineProperty(exports, "GameContext", { enumerable: true, get: function () { return gameContext_js_1.GameContext; } });
var gameStructure_js_1 = require("./gameStructure/gameStructure.js");
Object.defineProperty(exports, "GameStructure", { enumerable: true, get: function () { return gameStructure_js_1.GameStructure; } });
var scriptRunner_js_1 = require("./Runner/scriptRunner.js");
Object.defineProperty(exports, "ScriptRunner", { enumerable: true, get: function () { return scriptRunner_js_1.ScriptRunner; } });
Object.defineProperty(exports, "ScriptCancelledError", { enumerable: true, get: function () { return scriptRunner_js_1.ScriptCancelledError; } });
var RunnerManager_js_1 = require("./Runner/RunnerManager.js");
Object.defineProperty(exports, "RunnerManager", { enumerable: true, get: function () { return RunnerManager_js_1.RunnerManager; } });
__exportStar(require("./gameEvent/index.js"), exports);
__exportStar(require("./system/gameManager.js"), exports);
__exportStar(require("./system/globalPlayerManager.js"), exports);
var createGameModule_js_1 = require("./createGameModule.js");
Object.defineProperty(exports, "createGameModule", { enumerable: true, get: function () { return createGameModule_js_1.createGameModule; } });
