"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoStopState = void 0;
const main_js_1 = require("../../main.js");
const index_js_1 = require("../../utils/index.js");
/**自动在groupSet所有玩家寄了之后停止游戏 */
class AutoStopState extends main_js_1.GameState {
    onEnter() {
        if (!this.config?.groupSet)
            return;
        this.subscribe(main_js_1.Game.events.interval, this.tick.bind(this), new index_js_1.Duration(20));
    }
    tick() {
        let liveSize = 0;
        this.config.groupSet.getAllPlayers().forEach((p) => {
            if (p.ttl > 0)
                liveSize++;
            if (p.isValid) {
                p.ttl = p.initialTTL; //重置TTL
            }
            else if (p.ttl > 0) {
                p.ttl--; //下线的ttl减少
                if (this.config?.immediateDie)
                    p.ttl = 0;
                if (p.ttl == 0) {
                    this.config.onLeave?.(p);
                    //自动释放玩家
                    if (this.config?.shouldRelease ?? true)
                        main_js_1.Game.playerManager.releasePlayerFromGame(p.id, this.engine.key);
                }
            }
        });
        if (liveSize === 0) {
            this.logger.debug("检测到玩家已全部下线超时，游戏结束");
            this.engine.stopGame();
        }
    }
}
exports.AutoStopState = AutoStopState;
