"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GamePlayerManager = void 0;
const main_js_1 = require("../main.js");
const groupBuilder_js_1 = require("./groupBuilder.js");
/**游戏玩家管理器 */
class GamePlayerManager {
    gameKey;
    isDaemon;
    players = new Map();
    playerConstructor;
    /**玩家组构建器 */
    groupBuilder;
    constructor(playerConstructor, gameKey, isDaemon) {
        this.gameKey = gameKey;
        this.isDaemon = isDaemon;
        this.playerConstructor = playerConstructor;
        this.groupBuilder = new groupBuilder_js_1.PlayerGroupBuilder(this);
    }
    /**获取游戏玩家(若玩家已分配，返回无效玩家) */
    get(p) {
        //创建
        let gamePlayer = this.players.get(p.id);
        //若未创建或已失效，则重新创建并尝试分配
        if (!gamePlayer || !gamePlayer.isActive) {
            gamePlayer = new this.playerConstructor(p);
            this.players.set(p.id, gamePlayer);
            //申请分配玩家
            if (!this.isDaemon) {
                const ans = main_js_1.Game.playerManager.allocatePlayerToGame(p.id, this.gameKey);
                gamePlayer.isActive = ans;
            }
        }
        return gamePlayer;
    }
    getAll() {
        return Array.from(this.players.values());
    }
    /**让玩家失活 */
    deactivate(p) {
        let gamePlayer = this.players.get(p.id);
        if (gamePlayer) {
            gamePlayer.isActive = false; //强制修改活动状态
        }
    }
    get size() {
        return this.players.size;
    }
    get validSize() {
        return Array.from(this.players.values()).filter((p) => p.isValid)
            .length;
    }
    dispose() {
        main_js_1.Game.playerManager.releaseAllPlayerFromGame(this.gameKey);
    }
}
exports.GamePlayerManager = GamePlayerManager;
