"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemUseEventSignal = void 0;
const server_1 = require("@minecraft/server");
const mapEventSignal_js_1 = require("../mapEventSignal.js");
class ItemUseEventSignal extends mapEventSignal_js_1.BaseMapEventSignal {
    buildKey(options) {
        return options.itemId;
    }
    buildData(callback, options) {
        return {
            callback,
            itemId: options.itemId,
            players: options.players,
        };
    }
    extractKey(event) {
        return event.itemStack.typeId ?? null;
    }
    filter(data, event) {
        if (event.source instanceof server_1.Player &&
            data.players &&
            !data.players.getById(event.source.id)) {
            return false;
        }
        return true;
    }
    subscribeNative(cb) {
        server_1.world.afterEvents.itemUse.subscribe(cb);
        return cb;
    }
    unsubscribeNative(cb) {
        server_1.world.afterEvents.itemUse.unsubscribe(cb);
    }
}
exports.ItemUseEventSignal = ItemUseEventSignal;
