"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ButtonPushEventSignal = void 0;
const server_1 = require("@minecraft/server");
const vector_js_1 = require("../../utils/vector.js");
const mapEventSignal_js_1 = require("../mapEventSignal.js");
class ButtonPushEventSignal extends mapEventSignal_js_1.BaseMapEventSignal {
    buildKey(options) {
        const loc = vector_js_1.Vector3Utils.fromArray(options.loc);
        return `${options.dimensionId}-${loc.x}-${loc.y}-${loc.z}`;
    }
    buildData(callback, options) {
        return {
            callback,
            players: options.players,
            sourceType: options.sourceType,
        };
    }
    extractKey(event) {
        const loc = event.block.location;
        return `${event.dimension.id}-${loc.x}-${loc.y}-${loc.z}`;
    }
    filter(data, event) {
        if (data.sourceType && event.source.typeId !== data.sourceType)
            return false;
        if (event.source instanceof server_1.Player &&
            data.players &&
            !data.players.getById(event.source.id)) {
            return false;
        }
        return true;
    }
    subscribeNative(cb) {
        server_1.world.afterEvents.buttonPush.subscribe(cb);
        return cb;
    }
    unsubscribeNative(cb) {
        server_1.world.afterEvents.buttonPush.unsubscribe(cb);
    }
}
exports.ButtonPushEventSignal = ButtonPushEventSignal;
