"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegionProtector = void 0;
const server_1 = require("@minecraft/server");
const gameComponent_js_1 = require("../gameComponent.js");
class RegionProtector extends gameComponent_js_1.GameComponent {
    onAttach() {
        if (!this.options)
            return;
        // 处理破坏方块
        if (this.options.blockBreakInside || this.options.blockBreakOutside) {
            this.subscribe(server_1.world.beforeEvents.playerBreakBlock, (t) => {
                if (this.options?.groupSet &&
                    !this.options.groupSet.has(t.player.id)) {
                    return;
                }
                this.handleBreak(t);
            });
        }
        // 处理方块交互
        if (this.options.blockInteractOutside ||
            this.options.blockInteractInside) {
            this.subscribe(server_1.world.beforeEvents.playerInteractWithBlock, (t) => {
                if (this.options?.groupSet &&
                    !this.options.groupSet.has(t.player.id)) {
                    return;
                }
                this.handleInteract(t);
            });
        }
    }
    handleBreak(t) {
        if (this.options.blockBreakInside &&
            this.options.region.isBlockInside(t.block.location)) {
            t.cancel = true;
        }
        else if (this.options.blockBreakOutside &&
            !this.options.region.isBlockInside(t.block.location)) {
            t.cancel = true;
        }
    }
    handleInteract(t) {
        if (this.options.blockInteractInside &&
            this.options.region.isBlockInside(t.block.location)) {
            t.cancel = true;
        }
        else if (this.options.blockInteractOutside &&
            !this.options.region.isBlockInside(t.block.location)) {
            t.cancel = true;
        }
    }
}
exports.RegionProtector = RegionProtector;
