"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlayerRegionMonitor = void 0;
const main_js_1 = require("../../main.js");
const gameComponent_js_1 = require("../gameComponent.js");
/**玩家区域监测 */
class PlayerRegionMonitor extends gameComponent_js_1.GameComponent {
    onAttach() {
        if (!this.options)
            return;
        this.subscribe(main_js_1.Game.events.interval, () => this.detectOutOfRegionPlayers(), this.options.interval);
    }
    detectOutOfRegionPlayers() {
        const region = this.options.region;
        this.options.groups.forEach((p) => {
            if (!region.isInside(p.player.location)) {
                this.options.onLeave(p);
            }
        });
    }
}
exports.PlayerRegionMonitor = PlayerRegionMonitor;
