"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StopWatchTickEventSignal = void 0;
const index_js_1 = require("../../../utils/index.js");
class StopWatchTickEventSignal {
    tickCallbacks = new Set();
    logger = new index_js_1.Logger(this.constructor.name);
    constructor() { }
    /** 注册一个在每次时间增加（每秒）时执行的回调函数*/
    subscribe(callback) {
        this.tickCallbacks.add(callback);
        return {
            unsubscribe: () => {
                this.tickCallbacks.delete(callback);
            },
        };
    }
    publish(elapsedTime) {
        this.tickCallbacks.forEach((cb) => {
            try {
                cb({ elapsedTime: elapsedTime });
            }
            catch (err) {
                this.logger.error("stopWatch Tick事件执行错误", err);
            }
        });
    }
}
exports.StopWatchTickEventSignal = StopWatchTickEventSignal;
