"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createGameModule = createGameModule;
const gameComponent_js_1 = require("./gameComponent/gameComponent.js");
const gameEngine_js_1 = require("./gameEngine.js");
const gamePlayer_js_1 = require("./gamePlayer/gamePlayer.js");
const gameState_js_1 = require("./gameState/gameState.js");
function createGameModule(options) {
    const playerClass = options.playerClass ?? gamePlayer_js_1.GamePlayer;
    class Engine extends gameEngine_js_1.GameEngine {
        constructor(key, config) {
            super(playerClass, key, config);
        }
    }
    class State extends gameState_js_1.GameState {
    }
    class Component extends gameComponent_js_1.GameComponent {
    }
    return {
        Engine,
        State,
        Component,
    };
}
