"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.cleanFinally = cleanFinally;
exports.s0 = s0;
const node_fs_1 = __importDefault(require("node:fs"));
const zh_js_1 = __importDefault(require("./zh.js"));
const en_js_1 = __importDefault(require("./en.js"));
const node_path_1 = __importDefault(require("node:path"));
const langs = ["zh", "en"];
const configPath = node_path_1.default.join(require("node:os").homedir(), ".cache/mbler/.lang.db");
class Lang {
    currenyLang = "zh";
    init() {
        try {
            const TheyLang = node_fs_1.default.readFileSync(configPath, "utf-8").toString().trim();
            if (TheyLang == "zh" || TheyLang == "en") {
                this.currenyLang = TheyLang;
            }
            else {
                throw new Error("[setup lang]: set lang error");
            }
        }
        catch {
            this.currenyLang = "zh";
        }
    }
    set(newLang) {
        if (langs.includes(newLang)) {
            if (!node_fs_1.default.existsSync(configPath)) {
                node_fs_1.default.mkdirSync(node_path_1.default.dirname(configPath), {
                    recursive: true
                });
            }
            node_fs_1.default.writeFileSync(configPath, newLang);
            this.currenyLang = newLang;
            return true;
        }
        return false;
    }
    async get() {
        try {
            if (this.currenyLang == "zh")
                return zh_js_1.default;
            return en_js_1.default;
        }
        catch {
            return zh_js_1.default;
        }
    }
}
let exp = {};
async function Export(lang) {
    const obj = await lang.get();
    // 用原型来让导入后切换语言不需要再次导入，相同引用
    Object.setPrototypeOf(exp, {
        ...obj,
        __internal: {
            class: lang,
            set: (newLang) => {
                lang.set(newLang);
                Export(lang);
            }
        }
    });
}
const lang = new Lang();
lang.init();
Export(lang);
exports.default = exp;
function cleanFinally(arg0, cleanFinally) {
    throw new Error('Function not implemented.');
}
function s0(s0) {
    throw new Error('Function not implemented.');
}
