export declare function hasKeys(obj: any, keys: Array<string>, minValue: number): boolean;
export declare const input: (t: string, g?: boolean) => Promise<string>;
/**
 * 压缩目录为 ZIP，解压后根目录是 sourceDir 内的内容，而不是 sourceDir 文件夹本身
 * @param {Array} sourceDir 要压缩的目录路径，如 ['C:/data/myfolder' 或 '/home/user/myfolder']
 * @param {string} outputFile 输出的 ZIP 文件完整路径，如 'C:/backup/output.zip' 或 '/backup/output.zip'
 * @returns {Promise<boolean>} 是否压缩成功
 */
export declare function zip(sourceDir: string[], outputFile: string): Promise<void>;
export declare const waitGC: () => Promise<void>;
export declare function toString(t: any): string;
export declare function ToArray(str: string): number[];
export declare const sleep: (ms?: number) => Promise<void>;
export declare function readFileWithRetry(filePath: string, opt: {
    want: 'string';
    delay?: number;
    maxRetries?: number;
}): Promise<string>;
export declare function readFileWithRetry(filePath: string, opt: {
    want: 'object';
    delay?: number;
    maxRetries?: number;
}): Promise<Object>;
export declare const readFile: typeof readFileWithRetry;
export declare const JSONparse: (str: string) => any;
export declare function join(baseDir: string, inputPath: string): string;
export declare const isVerison: (str: string) => boolean;
export declare function Exit(msg: string): void;
export declare function FileExsit(dir: string): Promise<boolean>;
import type { MblerConfigData } from '../types';
export declare function GetData(dir: string): Promise<MblerConfigData>;
export declare function isMblerProject(Dir: string): Promise<boolean>;
import type { HandlerPackageResult, HandlerPackageDes } from '../types';
/**
 * 处理模块包配置，提取依赖、主入口、UI 配置等
 * @param {string} dir 模块目录路径
 * @param {Object} opt 可选参数（如：已处理的依赖列表）
 * @returns {Promise<Object>} { des: string[], ui: boolean, main: string }
 */
export declare function handlerPackage(dir: string, opt?: HandlerPackageDes): Promise<HandlerPackageResult>;
export declare function copy(src: string, out: string): Promise<void>;
declare const iconfig: any;
export { iconfig as config };
