/**
 * UI 表单封装类，用于根据配置动态创建、配置和显示 Minecraft 表单（如 Action、Modal、Message）。
 */
export class UI {
    /**
     * 构造函数
     * @param {string} name - 表单类型，如 "Action"、"Modal"、"Message"
     * @param {Object} logger - 日志对象，需实现 e() 和 w() 方法
     */
    constructor(name: string, logger: Object);
    form: any;
    formType: string;
    logger: Object;
    layoutGroup: any;
    /**
     * 设置表单标题
     * @param {string} newValue - 标题文本
     */
    set title(newValue: string);
    /**
     * 动态添加一个表单布局组件（如按钮、文本等）
     * @param {Object} opt - 配置项
     * @param {string} opt.type - 布局类型，如 "button"
     * @param {Array<any>} opt.param - 对应该布局的参数列表
     */
    addLayout(opt: {
        type: string;
        param: Array<any>;
    }): void;
    /**
     * 显示表单给玩家
     * @param {@minecraft/server.Player} player - Minecraft 玩家对象
     * @param {boolean = false} UseBeta - 使用新版 UI 库特性吗，兼容旧版
     */
    show(player: any, UseBeta?: boolean): any;
    #private;
}
export function createForm(logger: Object, name: string, opt: Object): UI;
export function regLayout(layout: any): any[];
