"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.Vector3Utils=void 0;class Vector3Utils{static distance(t,r){return Math.sqrt(this.squaredDistance(t,r))}static squaredDistance(t,r){return Math.pow(r.x-t.x,2)+Math.pow(r.y-t.y,2)+Math.pow(r.z-t.z,2)}static toArray(t){return[t.x,t.y,t.z]}static toString(t,r=","){return this.toArray(t).join(r)}static fromArray(t){if(3!==t.length)throw new Error("必须为长度为3的数组");if(!t.every(Number.isFinite))throw new Error("数组必须包含数字");return{x:t[0],y:t[1],z:t[2]}}static clone(t){return Object.assign({},t)}static add(t,r){return{x:t.x+r.x,y:t.y+r.y,z:t.z+r.z}}static subtract(t,r){return{x:t.x-r.x,y:t.y-r.y,z:t.z-r.z}}static scale(t,r){return{x:t.x*r,y:t.y*r,z:t.z*r}}static isEqual(t,r){return t.x===r.x&&t.y===r.y&&t.z===r.z}static isApproxEqual(t,r,s=1e-6){return Math.abs(t.x-r.x)<s&&Math.abs(t.y-r.y)<s&&Math.abs(t.z-r.z)<s}static length(t){return Math.sqrt(t.x*t.x+t.y*t.y+t.z*t.z)}static dot(t,r){return t.x*r.x+t.y*r.y+t.z*r.z}static cross(t,r){return{x:t.y*r.z-t.z*r.y,y:t.z*r.x-t.x*r.z,z:t.x*r.y-t.y*r.x}}static normalize(t){const r=this.length(t);return 0===r?{x:0,y:0,z:0}:{x:t.x/r,y:t.y/r,z:t.z/r}}static above(t,r=1){return this.add(t,{x:0,y:r,z:0})}static below(t,r=1){return this.subtract(t,{x:0,y:r,z:0})}static intPos(t){return{x:Math.floor(t.x),y:Math.floor(t.y),z:Math.floor(t.z)}}}exports.Vector3Utils=Vector3Utils;