"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.GameState=void 0;const eventManager_js_1=require("../gameEvent/eventManager.js"),RunnerManager_js_1=require("../Runner/RunnerManager.js"),logger_js_1=require("../utils/logger.js"),types_js_1=require("./types.js");class GameState{logger=new logger_js_1.Logger(this.constructor.name);engine;components=new Map;eventManager=new eventManager_js_1.EventManager;runner=new RunnerManager_js_1.RunnerManager(this.constructor.name);config;constructor(e,t){this.engine=e,this.config=t}get context(){return this.engine.context}get playerManager(){return this.engine.playerManager}get gameKey(){return this.engine.key}get nextState(){return this.engine.getNextState(this)}get lastState(){return this.engine.getLastState(this)}addComponent(e,t,n){if(!this.engine.isActive)return this;this.logger.debug(`添加组件:${e.name}`+(null!=n?`(tag=${n})`:""));const s=this.components.get(e)??[];if(s.some(e=>e.tag===n))throw new types_js_1.GameComponentAlreadyExistsError(e,n);this.components.has(e)||this.components.set(e,s);const r=new e(this,t,n);s.push(r);try{r._onAttach()}catch(t){this.logger.error(`组件 ${e.name} tag=${n} 加载失败`,t)}return this}addComponents(e){for(const t of e)this.addComponent(t)}getComponent(e,t){const n=this.components.get(e),s=n?.find(e=>e.tag===t);if(!s)throw new types_js_1.GameComponentNotExistsError(e,t);return s}deleteComponent(e,t){this.logger.debug(`删除组件:${e.name}`);const n=this.components.get(e);if(!n)return this;const s=n?.findIndex(e=>e.tag===t);if(-1===s)return this;const r=n[s];try{r._onDetach(),n.splice(s,1),0===n.length&&this.components.delete(e)}catch(t){throw new types_js_1.ComponentDeleteFailedError(e,r.tag,{cause:t})}return this}deleteAllComponents(){this.logger.debug("删除所有组件");for(let[e,t]of this.components.entries())for(const n of t){const t=n;try{t._onDetach()}catch(n){throw new types_js_1.ComponentDeleteFailedError(e,t.tag,{cause:n})}}this.components.clear()}subscribe(e,...t){return this.eventManager.subscribe(this,e,...t)}pushState(e,t){this.engine.pushState(e,t)}popState(){this.engine.popState()}transitionTo(e,t){this.engine.replaceFrom(this,e,t)}_onExit(){this.logger.debug("onExit"),this.onExit(),this.eventManager.dispose(),this.deleteAllComponents(),this.runner.dispose()}onExit(){}stats(){const e=this.constructor.name,t=[...this.components.values()].map(e=>e.map(e=>e.constructor.name+(null!=e.tag?`(tag=${e.tag})`:""))).flat();return`§b${e}§r(${t.length}): §i${t.length?t.join(","):"<none>"}`}}exports.GameState=GameState;