/**游戏状态 */
export class GameState {
    constructor(engine: any, config: any);
    logger: Logger;
    engine: any;
    components: Map<any, any>;
    eventManager: EventManager;
    runner: RunnerManager;
    config: any;
    /**全局上下文 */
    get context(): any;
    /**玩家管理器 */
    get playerManager(): any;
    get gameKey(): any;
    /**获取子状态 */
    get nextState(): any;
    get lastState(): any;
    /**
     * 添加组件到当前状态
     * @param component 组件类型
     * @param options 组件参数
     * @param tag 组件标签(唯一)
     * @throws {GameComponentAlreadyExistsError} 组件已存在时抛出
     * @throws {ComponentLoadFailedError} 组件加载失败时抛出
     */
    addComponent(component: any, options: any, tag: any): this;
    /**添加多个components(不能带参数和tag) */
    addComponents(components: any): void;
    /**
     * 获取当前状态中的组件
     * @param type 组件类型
     * @param tag 组件标签
     * @throws {GameComponentNotExistsError} 若组件不存在，则抛出
     */
    getComponent(type: any, tag: any): any;
    /**删除当前状态中的组件
     * @throws {ComponentDeleteFailedError} 组件删除失败时
     */
    deleteComponent(component: any, tag: any): this;
    /**删除所有组件
     * @throws {ComponentDeleteFailedError} 删除失败时
     */
    deleteAllComponents(): void;
    subscribe(event: any, ...args: any[]): import("../gameEvent/eventManager.js").EventSubscription | undefined;
    /** 进入一个新的子状态 */
    pushState(stateType: any, config: any): void;
    /** 返回到父状态 */
    popState(): void;
    /**将当前状态及其所有子状态，替换为一个新状态。*/
    transitionTo(stateType: any, config: any): void;
    _onExit(): void;
    onExit(): void;
    /**返回基本信息 */
    stats(): string;
}
import { Logger } from "../utils/logger.js";
import { EventManager } from "../gameEvent/eventManager.js";
import { RunnerManager } from "../Runner/RunnerManager.js";
