"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.PlaneRegion=exports.CylinderRegion=exports.SphereRegion=exports.CubeRegion=exports.GameRegion=void 0;const server_1=require("@minecraft/server"),vector_js_1=require("../utils/vector.js");class GameRegion{dimensionId;constructor(s){this.dimensionId=s}getPlayersInRegion(){const s=[],t=server_1.world.getAllPlayers();for(const i of t)null!=i&&i.dimension.id==this.dimensionId&&this.isInside(i.location)&&s.push(i);return s}getEntitesInRegion(s){return server_1.world.getDimension(this.dimensionId).getEntities({...this.getEntityQueryOption(),...s}).filter(s=>null!=s)}runCommandOnPlayers(s){this.getPlayersInRegion().forEach(t=>t.runCommand(s))}forEachPlayer(s){this.getPlayersInRegion().forEach(s)}}exports.GameRegion=GameRegion;class CubeRegion extends GameRegion{pos1;pos2;constructor(s,t,i){super(s),this.pos1=t,this.pos2=i}getEntityQueryOption(){return{location:this.pos1,volume:vector_js_1.Vector3Utils.subtract(this.pos2,this.pos1)}}isInside(s){const t=1e-5,i=Math.min(this.pos1.x,this.pos2.x),o=Math.max(this.pos1.x,this.pos2.x)+1,e=Math.min(this.pos1.y,this.pos2.y),n=Math.max(this.pos1.y,this.pos2.y)+.99,h=Math.min(this.pos1.z,this.pos2.z),r=Math.max(this.pos1.z,this.pos2.z)+1,p=s.x+t>=i&&s.x-t<=o,a=s.y+t>=e&&s.y-t<=n,x=s.z+t>=h&&s.z-t<=r;return p&&a&&x}isBlockInside(s){const t=Math.min(this.pos1.x,this.pos2.x),i=Math.max(this.pos1.x,this.pos2.x),o=Math.min(this.pos1.y,this.pos2.y),e=Math.max(this.pos1.y,this.pos2.y),n=Math.min(this.pos1.z,this.pos2.z),h=Math.max(this.pos1.z,this.pos2.z),r=s.x>=t&&s.x<=i,p=s.y>=o&&s.y<=e,a=s.z>=n&&s.z<=h;return r&&p&&a}toVolume(){return new server_1.BlockVolume(this.pos1,this.pos2)}getCapacity(){const s=vector_js_1.Vector3Utils.add(vector_js_1.Vector3Utils.subtract(this.getMax(),this.getMin()),{x:1,y:1,z:1});return Math.abs(s.x*s.y*s.z)}getBounds(){return{x1:this.pos1.x,x2:this.pos2.x,y1:this.pos1.y,y2:this.pos2.y,z1:this.pos1.z,z2:this.pos2.z}}outSet(s){const t=Math.min(this.pos1.x,this.pos2.x)-s.x,i=Math.max(this.pos1.x,this.pos2.x)+s.x,o=Math.min(this.pos1.y,this.pos2.y)-s.y,e=Math.max(this.pos1.y,this.pos2.y)+s.y,n=Math.min(this.pos1.z,this.pos2.z)-s.z,h=Math.max(this.pos1.z,this.pos2.z)+s.z;return new CubeRegion(this.dimensionId,{x:t,y:o,z:n},{x:i,y:e,z:h})}inSet(s){const t=Math.min(this.pos1.x,this.pos2.x)+s.x,i=Math.max(this.pos1.x,this.pos2.x)-s.x,o=Math.min(this.pos1.y,this.pos2.y)+s.y,e=Math.max(this.pos1.y,this.pos2.y)-s.y,n=Math.min(this.pos1.z,this.pos2.z)+s.z,h=Math.max(this.pos1.z,this.pos2.z)-s.z;if(!(t>=i||o>=e||n>=h))return new CubeRegion(this.dimensionId,{x:t,y:o,z:n},{x:i,y:e,z:h})}getMax(){return{x:Math.max(this.pos1.x,this.pos2.x),y:Math.max(this.pos1.y,this.pos2.y),z:Math.max(this.pos1.z,this.pos2.z)}}getMin(){return{x:Math.min(this.pos1.x,this.pos2.x),y:Math.min(this.pos1.y,this.pos2.y),z:Math.min(this.pos1.z,this.pos2.z)}}}exports.CubeRegion=CubeRegion;class SphereRegion extends GameRegion{center;r;rm;constructor(s,t,i,o){super(s),this.center=t,this.r=i,this.rm=o}getEntityQueryOption(){return{location:this.center,maxDistance:this.r,minDistance:this.rm}}isInside(s){return vector_js_1.Vector3Utils.squaredDistance(this.center,s)<=this.r*this.r}isBlockInside(s){return this.isInside(s)}}exports.SphereRegion=SphereRegion;class CylinderRegion extends GameRegion{getEntityQueryOption(){throw new Error("Method not implemented.")}isInside(s){throw new Error("Method not implemented.")}isBlockInside(s){return this.isInside(s)}}exports.CylinderRegion=CylinderRegion;class PlaneRegion extends GameRegion{pos1;pos2;constructor(s,t,i){super(s),this.pos1=t,this.pos2=i}getEntityQueryOption(){return{location:{x:this.pos1.x,y:-1e3,z:this.pos1.y},volume:{x:this.pos2.x-this.pos1.x,z:this.pos2.y-this.pos1.y,y:2e3}}}isInside(s){const t=1e-5,i=Math.min(this.pos1.x,this.pos2.x),o=Math.max(this.pos1.x,this.pos2.x)+1,e=Math.min(this.pos1.y,this.pos2.y),n=Math.max(this.pos1.y,this.pos2.y)+1,h=s.x+t>=i&&s.x-t<=o,r=s.y+t>=e&&s.y-t<=n;return h&&r}isBlockInside(s){const t=Math.min(this.pos1.x,this.pos2.x),i=Math.max(this.pos1.x,this.pos2.x),o=Math.min(this.pos1.y,this.pos2.y),e=Math.max(this.pos1.y,this.pos2.y),n=s.x>=t&&s.x<=i,h=s.y>=o&&s.y<=e;return n&&h}}exports.PlaneRegion=PlaneRegion;