/**游戏区域 */
export class GameRegion {
    constructor(dimId: any);
    dimensionId: any;
    /**获取区域内的玩家 */
    getPlayersInRegion(): import("@minecraft/server").Player[];
    /**获取区域内实体 */
    getEntitesInRegion(options: any): import("@minecraft/server").Entity[];
    /** 在区域内的玩家执行命令 */
    runCommandOnPlayers(commandString: any): void;
    /**对每个玩家执行操作 */
    forEachPlayer(callbackfn: any): void;
}
/**立方体区域 */
export class CubeRegion extends GameRegion {
    constructor(dimId: any, pos1: any, pos2: any);
    pos1: any;
    pos2: any;
    getEntityQueryOption(): {
        location: any;
        volume: import("@minecraft/server").Vector3;
    };
    /**判断是否在区域内 */
    isInside(loc: any): boolean;
    /**判断方块是否在区域内 */
    isBlockInside(loc: any): boolean;
    /**转换为BlockVolume */
    toVolume(): BlockVolume;
    /**获取大小 */
    getCapacity(): number;
    /**获取范围 */
    getBounds(): {
        x1: any;
        x2: any;
        y1: any;
        y2: any;
        z1: any;
        z2: any;
    };
    /**向外扩张区域 */
    outSet(distance: any): CubeRegion;
    /**向内收缩区域（若收缩后无体积则返回 undefined） */
    inSet(distance: any): CubeRegion | undefined;
    /**获取区域最大点坐标 */
    getMax(): {
        x: number;
        y: number;
        z: number;
    };
    /**获取区域最小点坐标 */
    getMin(): {
        x: number;
        y: number;
        z: number;
    };
}
/**球形区域 */
export class SphereRegion extends GameRegion {
    constructor(dimId: any, center: any, r: any, rm: any);
    center: any;
    r: any;
    rm: any;
    getEntityQueryOption(): {
        location: any;
        maxDistance: any;
        minDistance: any;
    };
    isInside(loc: any): boolean;
    isBlockInside(loc: any): boolean;
}
export class CylinderRegion extends GameRegion {
    getEntityQueryOption(): void;
    isInside(loc: any): void;
    isBlockInside(loc: any): void;
}
/**平面区域 */
export class PlaneRegion extends GameRegion {
    constructor(dimId: any, pos1: any, pos2: any);
    pos1: any;
    pos2: any;
    getEntityQueryOption(): {
        location: {
            x: any;
            y: number;
            z: any;
        };
        volume: {
            x: number;
            z: number;
            y: number;
        };
    };
    isInside(loc: any): boolean;
    isBlockInside(loc: any): boolean;
}
import { BlockVolume } from "@minecraft/server";
