export class RunnerManager {
    constructor(stateName: any);
    runners: Map<any, any>;
    idCounter: number;
    logger: Logger;
    /**返回一个新的scriptRunner(需手动捕获错误) */
    "new"(): {
        id: string;
        runner: ScriptRunner;
    };
    /**
     * 运行普通脚本
     */
    run(script: any): string;
    runDelay(script: any, ticks: any): string;
    /**
     * 使用游戏 runJob 运行 generator
     */
    runJob(generator: any): {
        id: string;
        promise: Promise<any>;
    };
    /**
     * 取消指定 runner 或 job
     */
    cancel(id: any): boolean;
    /**
     * 取消所有 runner/job
     */
    dispose(): void;
    get size(): number;
}
import { Logger } from "../utils/index.js";
import { ScriptRunner } from "./scriptRunner.js";
