import type { MblerConfigData } from './../types.js';
import type { BuildData } from './index.js';
export declare abstract class BaseBuild {
    #private;
    [x: string]: any;
    static times: string;
    outdir: string;
    ResOutDir: string | null;
    baseCwd: string;
    cwd: string;
    ResCwd: string;
    d_data: BuildData | null;
    cacheDir: string;
    dependencies: Record<string, string>;
    Modules: string[];
    protected constructor();
    rmPackScriptScriptCache(): Promise<void>;
    processResources(): Promise<void>;
    processDist(): Promise<void>;
    loadPackageData(): Promise<MblerConfigData>;
    getCachePath(fileName: string): string;
    getOutputDir(dir: string | null | undefined, def: string): string;
    initNpmDes(): Promise<void>;
    getFileHash(filePath: string): Promise<string | null>;
    chackConfigHash(): Promise<{
        configChanged: boolean;
        packageChanged: boolean;
    }>;
    removeJsFiles(dir: string): Promise<void>;
    rmNpmDes(): Promise<void>;
    copyCompiledOnly(srcDir: string, destDir: string): Promise<void>;
    getAllTsFiles(dir: string): Promise<string[]>;
    writeFile(filePath: string, content: string | object): Promise<void>;
}
